<?php

/*
* @author mypos Holdings Ltd.
* @version $Id: mypos.php 7487 2013-12-17 15:03:42Z alatak $
* @package VirtueMart
* @subpackage payment
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* VirtueMart is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See /administrator/components/com_virtuemart/COPYRIGHT.php for copyright notices and details.
*
* http://virtuemart.org
*/

defined('_JEXEC') or die('Restricted access');
if (!class_exists('vmPSPlugin')) {
    require(JPATH_VM_PLUGINS . DS . 'vmpsplugin.php');
}

const PAYMENT_METHOD_CARD = '1';
const PAYMENT_METHOD_IDEAL = '2';
const PAYMENT_METHOD_BOTH = '3';

const WAITING_CONFIRMATION_PERIOD_HOURS = '8';
const WAITING_CONFIRMATION_DEADLINE_HOURS = '24'; //Hours after the order change his status as canceled

class plgVmpaymentmypos extends vmPSPlugin
{

    function __construct(&$subject, $config)
    {

        parent::__construct($subject, $config);


        // unique filelanguage for all mypos methods
        $jlang = JFactory::getLanguage();
        $jlang->load('plg_vmpayment_mypos', JPATH_ADMINISTRATOR, NULL, TRUE);
        $this->_loggable = TRUE;
        $this->_debug = FALSE;
        $this->tableFields = array_keys($this->getTableSQLFields());
        $this->_tablepkey = 'id'; //virtuemart_mypos_id';
        $this->_tableId = 'id'; //'virtuemart_mypos_id';
        $varsToPush = array(
            'test' => array('', 'int'),
            //'use_deadline_for_orders' => array('', 'char'),

            //Production data
            'production_package' => array('', 'char'),
            'production_sid' => array('', 'char'),
            'production_wallet_number' => array('', 'char'),
            'production_private_key' => array('', 'char'),
            'production_public_certificate' => array('', 'char'),
            'production_keyindex' => array('', 'char'),
            'production_url' => array('', 'char'),
            'production_ppr' => array('', 'int'),
            'production_payment_method' => array('', 'int'),

            //Developer data
            'developer_package' => array('', 'char'),
            'developer_sid' => array('', 'char'),
            'developer_wallet_number' => array('', 'char'),
            'developer_private_key' => array('', 'char'),
            'developer_public_certificate' => array('', 'char'),
            'developer_keyindex' => array('', 'char'),
            'developer_url' => array('', 'char'),
            'developer_ppr' => array('', 'int'),
            'developer_payment_method' => array('', 'int')
        );
        $this->addVarsToPushCore($varsToPush, 1);
        $this->setConfigParameterable($this->_configTableFieldName, $varsToPush);

        //Test mode prefix for maintaining unique irder ID
        $this->test_prefix = uniqid() . '_';
          
        $document = JFactory::getDocument();
        $document->addStyleSheet(JURI::root() . '/plugins/vmpayment/mypos/joomlaadmin.css');

    }

    function getTableSQLFields()
    {

        $SQLfields = array('id' => 'int(11) UNSIGNED NOT NULL AUTO_INCREMENT',
            'virtuemart_order_id' => 'int(1) UNSIGNED',
            'order_number' => ' char(64)',
            'virtuemart_paymentmethod_id'
            => 'mediumint(1) UNSIGNED',
            'payment_name' => 'varchar(5000)',
            'payment_order_total' => 'decimal(15,5) NOT NULL DEFAULT \'0.00000\'',
            'payment_currency' => 'char(3) ',
            'cost_per_transaction' => 'decimal(10,2)',
            'cost_percent_total' => 'decimal(10,2)',
            'tax_id' => 'smallint(1)',

            'user_session' => 'varchar(255)',

            // status report data returned by mypos to the merchant
            'mb_pay_to_email' => 'varchar(50)',
            'mb_pay_from_email' => 'varchar(50)',
            'mb_merchant_id' => 'int(10) UNSIGNED',
            'mb_transaction_id' => 'varchar(15)',
            'mb_rec_payment_id' => 'int(10) UNSIGNED',
            'mb_rec_payment_type' => 'varchar(16)',
            'mb_amount' => 'decimal(19,2)',
            'mb_currency' => 'char(3)',
            'mb_status' => 'tinyint(1)',
            'mb_md5sig' => 'char(32)',
            'mb_sha2sig' => 'char(64)',
            'mbresponse_raw' => 'varchar(512)',

            // pending payment specific fields (not used)
            'last_check' => 'int NULL',
            'expired_time' => 'int NOT NULL',
            'test_environment' => 'boolean NOT NULL');

        return $SQLfields;
    }

    public function getVmPluginCreateTableSQL()
    {

        return $this->createTableSQL('Payment mypos Table');
    }

    function plgVmConfirmedOrder($cart, $order)
    {

        if (!($method = $this->getVmPluginMethod($order['details']['BT']->virtuemart_paymentmethod_id))) {
            return NULL;
        } // Another method was selected, do nothing

        if (!$this->selectedThisElement($method->payment_element)) {
            return FALSE;
        }

        $session = JFactory::getSession();
        $return_context = $session->getId();
        $this->logInfo('plgVmConfirmedOrder order number: ' . $order['details']['BT']->order_number, 'message');

        if (!class_exists('VirtueMartModelOrders')) {
            require(VMPATH_ADMIN . DS . 'models' . DS . 'orders.php');
        }
        if (!class_exists('VirtueMartModelCurrency')) {
            require(VMPATH_ADMIN . DS . 'models' . DS . 'currency.php');
        }

        $usrBT = $order['details']['BT'];
        $address = ((isset($order['details']['ST'])) ? $order['details']['ST'] : $order['details']['BT']);

        if (!class_exists('TableVendors')) {
            require(VMPATH_ADMIN . DS . 'tables' . DS . 'vendors.php');
        }
        $vendorModel = VmModel::getModel('Vendor');
        $vendorModel->setId(1);
        $vendor = $vendorModel->getVendor();
        $vendorModel->addImages($vendor, 1);
        $this->getPaymentCurrency($method);

        $q = 'SELECT `currency_code_3` FROM `#__virtuemart_currencies` WHERE `virtuemart_currency_id`="' .
            $method->payment_currency . '" ';
        $db = JFactory::getDBO();
        $db->setQuery($q);
        $currency_code_3 = $db->loadResult();

        $totalInPaymentCurrency = vmPSPlugin::getAmountInCurrency($order['details']['BT']->order_total, $method->payment_currency);
        $cartCurrency = CurrencyDisplay::getInstance($cart->pricesCurrency);

        if ($totalInPaymentCurrency['value'] <= 0) {
            vmInfo(vmText::_('VMPAYMENT_mypos_PAYMENT_AMOUNT_INCORRECT'));
            return FALSE;
        }


        $lang = JFactory::getLanguage();


        // Prepare data that should be stored in the database
        $dbValues['user_session'] = $return_context;
        $dbValues['order_number'] = $order['details']['BT']->order_number;
        $dbValues['payment_name'] = $this->renderPluginName($method, $order);
        $dbValues['virtuemart_paymentmethod_id'] = $cart->virtuemart_paymentmethod_id;
        $dbValues['cost_per_transaction'] = $method->cost_per_transaction;
        $dbValues['cost_percent_total'] = $method->cost_percent_total;
        $dbValues['payment_currency'] = $method->payment_currency;
        $dbValues['payment_order_total'] = $totalInPaymentCurrency['value'];
        $dbValues['tax_id'] = $method->tax_id;
        $this->storePSPluginInternalData($dbValues);


        $burl = $this->getPostParameters($cart, $method, $address, $order, round($totalInPaymentCurrency['value'], 2));

        // Render HTML form
        $html .= $burl;

        $cart->emptyCart();
        vRequest::setVar('html', $html);
    }

    static function getPaymentCurrency(&$method, $selectedUserCurrency = false)
    {

        if (empty($method->payment_currency)) {
            $vendor_model = VmModel::getModel('vendor');
            $vendor = $vendor_model->getVendor($method->virtuemart_vendor_id);
            $method->payment_currency = $vendor->vendor_currency;
            return $method->payment_currency;
        } else {

            $vendor_model = VmModel::getModel('vendor');
            $vendor_currencies = $vendor_model->getVendorAndAcceptedCurrencies($method->virtuemart_vendor_id);

            if (!$selectedUserCurrency) {
                if ($method->payment_currency == -1) {
                    $mainframe = JFactory::getApplication();
                    $selectedUserCurrency = $mainframe->getUserStateFromRequest("virtuemart_currency_id", 'virtuemart_currency_id', vRequest::getInt('virtuemart_currency_id', $vendor_currencies['vendor_currency']));
                } else {
                    $selectedUserCurrency = $method->payment_currency;
                }
            }

            $vendor_currencies['all_currencies'] = explode(',', $vendor_currencies['all_currencies']);
            if (in_array($selectedUserCurrency, $vendor_currencies['all_currencies'])) {
                $method->payment_currency = $selectedUserCurrency;
            } else {
                $method->payment_currency = $vendor_currencies['vendor_currency'];
            }

            return $method->payment_currency;
        }

    }

    /**
     * Generate myPOS Checkout form
     */

    private function getPostParameters($cart, $method, $address, $order, $order_total)
    {
        $this->logInfo('Create post data for order: ' . $order['details']['BT']->virtuemart_order_id, 'message');
        $lang = JFactory::getLanguage();

        $q = 'SELECT `currency_code_3` FROM `#__virtuemart_currencies` WHERE `virtuemart_currency_id`="' .
            $method->payment_currency . '" ';
        $db = JFactory::getDBO();
        $db->setQuery($q);
        $currency_code_3 = $db->loadResult();
        $notify_url = JURI::root() .
            'index.php?option=com_virtuemart&view=pluginresponse&task=pluginnotification&tmpl=component&pm=' .
            $order['details']['BT']->virtuemart_paymentmethod_id;

        //$id = "mypos";
        $version = '1.4';

        // Define user set variables

        $test = $method->test;

        if (!$test) {
            $packageData = json_decode(base64_decode($method->production_package), true);

            $sid = !empty($packageData['sid']) ? $packageData['sid'] : $method->production_sid;
            $wallet_number = !empty($packageData['cn']) ? $packageData['cn'] : $method->production_wallet_number;
            $private_key = !empty($packageData['pk']) ? $packageData['pk'] : $method->production_private_key;
            $public_certificate = !empty($packageData['pc']) ? $packageData['pc'] : $method->production_public_certificate;
            $keyindex = !empty($packageData['idx']) ? $packageData['idx'] : $method->production_keyindex;
            $url = $method->production_url;
            $paymentParametersRequired = $method->production_ppr;
            $paymentMethod = 1; //$method->production_payment_method;
        } else {
            $packageData = json_decode(base64_decode($method->developer_package), true);

            $sid = !empty($packageData['sid']) ? $packageData['sid'] : $method->developer_sid;
            $wallet_number = !empty($packageData['cn']) ? $packageData['cn'] : $method->developer_wallet_number;
            $private_key = !empty($packageData['pk']) ? $packageData['pk'] : $method->developer_private_key;
            $public_certificate = !empty($packageData['pc']) ? $packageData['pc'] : $method->developer_public_certificate;
            $keyindex = !empty($packageData['idx']) ? $packageData['idx'] : $method->developer_keyindex;
            $url = $method->developer_url;
            $paymentParametersRequired = 1; //$method->developer_ppr;
            $paymentMethod = 1; //$method->developer_payment_method;

        }

        //$hasDeadlinePendingOrder = $method->use_deadline_for_orders;

        $post = array();

        $post['IPCmethod'] = 'IPCPurchase';
        $post['IPCVersion'] = $version;
        $post['IPCLanguage'] = strtoupper(substr($lang->get('tag'), 0, 2));
        $post['WalletNumber'] = $wallet_number;
        $post['SID'] = $sid;
        $post['keyindex'] = $keyindex;
        $post['Source'] = 'Joomla&VirtueMart';

        $post['Amount'] = number_format($order_total, 2, '.', '');
        $post['Currency'] = $currency_code_3;
        $post['OrderID'] = ($test ? $this->test_prefix : '') . str_pad($order['details']['BT']->virtuemart_order_id, 6, "0", STR_PAD_LEFT);
        $post['URL_OK'] = JURI::root() .
            'index.php?option=com_virtuemart&view=orders&layout=details&order_number=' . $order['details']['BT']->order_number . '&order_pass=' . $order['details']['BT']->order_pass;
        //'index.php?option=com_virtuemart&view=cart&Itemid=' . vRequest::getInt('Itemid');
        // $post['URL_CANCEL'] = JURI::root() .    
        //     'index.php?option=com_virtuemart&view=orders&layout=details&order_number=' . $order['details']['BT']->order_number . '&order_pass=' . $order['details']['BT']->order_pass;
        $post['URL_CANCEL'] = JURI::root() . 'index.php?option=com_virtuemart&view=cart';
        $post['URL_Notify'] = $notify_url;
        $post['CustomerIP'] = $_SERVER['REMOTE_ADDR'];

        //$post['CustomerEmail'] = $address->email;
        $post['CustomerEmail'] = (!isset($address->email) ? $order['details']['BT']->email : $address->email);
        $post['CustomerFirstNames'] = str_replace(array('"', "'"), '', trim(html_entity_decode(strip_tags($address->first_name))));
        // $post['CustomerFirstNames'] = $address->first_name;
        // $post['CustomerFamilyName'] = $address->last_name;
        $post['CustomerFamilyName'] = str_replace(array('"', "'"), '', trim(html_entity_decode(strip_tags($address->last_name))));
        $post['CustomerCountry'] = ShopFunctions::getCountryByID($address->virtuemart_country_id, 'country_3_code');
        $post['CustomerCity'] = $address->city;
        $post['CustomerZIPCode'] = $address->zip;
        // $post['CustomerAddress'] = $address->address_1;
        $post['CustomerAddress'] = str_replace(array('"', "'"), '', trim(html_entity_decode(strip_tags($address->address_1))));
        $post['CustomerPhone'] = $address->phone_1;
        $post['Note'] = 'myPOS Checkout Virtuemart Extension. Order Number: ' . $order['details']['BT']->order_number;

        $post['CardTokenRequest'] = 0;
        $post['PaymentParametersRequired'] = $paymentParametersRequired;
        $post['PaymentMethod'] = $paymentMethod;


        $sumOfCartProducts = 0;
        
        // Get all products in cart - this method requires separate products
        $i = 1;
        foreach ($cart->products as $key => $product) {
            $post["Article_" . $i] = $this->escape_string(substr(strip_tags($product->product_name), 0, 127));
            $post["Quantity_" . $i] = $product->quantity;
            $post["Price_" . $i] = number_format($cart->pricesUnformatted[$key]['salesPrice'], 2, '.', '');
            $post["Amount_" . $i] = number_format($cart->pricesUnformatted[$key]['salesPrice'] * $product->quantity, 2, '.', '');
            $post["Currency_" . $i] = $currency_code_3;
            $i++;
            
             $sumOfCartProducts += ($cart->pricesUnformatted[$key]['salesPrice'] * $product->quantity);
        }

        // Shipment
        $post["Article_" . $i] = $this->escape_string(strip_tags($cart->cartData['shipmentName']));
        $post["Quantity_" . $i] = 1;
        $post["Price_" . $i] = number_format($cart->cartPrices['salesPriceShipment'], 2, '.', '');
        $post["Amount_" . $i] = number_format($cart->cartPrices['salesPriceShipment'], 2, '.', '');
        $post["Currency_" . $i] = $currency_code_3;
        $i++;


        $discountcheck = ROUND($order_total - $sumOfCartProducts,2);
        
        // var_dump($discountcheck); die();
        
        if ($discountcheck < -0.01 ) {

            // Discount 
            $post["Article_" . $i] = "Discount";
            $post["Quantity_" . $i] = 1;
            $post["Price_" . $i] = number_format($order_total - $sumOfCartProducts, 2, '.', '');
            $post["Amount_" . $i] = number_format($order_total - $sumOfCartProducts, 2, '.', '');
            
            // $post["Price_" . $i] =  "-".$post["Price_" . $i];
            // $post["Amount_" . $i] = "-".$post["Amount_" . $i];
            
            $post["Currency_" . $i] = $currency_code_3;
            $i++;
        }

        $post['CartItems'] = $i - 1;
        $post['trp-form-language'] = $post['IPCLanguage'];
        $post['Signature'] = $this->create_signature($post, $private_key);

        foreach ($post as $key => $value) {
            // $value = htmlspecialchars($value, ENT_QUOTES);
            $post_array[] = "<input type='hidden' name='$key' value='$value'/>";
        }
        $form = "<br><br><form id='Payment_form' method='post' action='$url'>";
        $form .= implode('', $post_array);
        $form .= "<noscript><input type='submit' value='Направи плащане с myPOS' class='button'></noscript>";
        $form .= "<br><br></form><br><br><script type='text/javascript'>document.getElementById('Payment_form').submit();</script>";
        $form .= "<input type='submit' value='Направи плащане с myPOS' class='button'>";
        $form .= "<br><br></form><br><br>";


        return $form;
    }

    protected function escape_string($string)
    {
        return strip_tags(htmlspecialchars_decode(str_replace("\r", "", str_replace("\n", "", $string))));
    }

    private function create_signature($post, $private_key)
    {
        $this->logInfo("Create signature for order: " . $post['OrderID']);

        $concData = base64_encode(implode('-', $post));
        $privKeyObj = openssl_get_privatekey($private_key);
        openssl_sign($concData, $signature, $privKeyObj, OPENSSL_ALGO_SHA256);
        return base64_encode($signature);
    }

    function plgVmgetPaymentCurrency($virtuemart_paymentmethod_id, &$paymentCurrencyId)
    {

        if (!($method = $this->getVmPluginMethod($virtuemart_paymentmethod_id))) {
            return NULL;
        } // Another method was selected, do nothing

        if (!$this->selectedThisElement($method->payment_element)) {
            return FALSE;
        }

        $this->getPaymentCurrency($method);
        $paymentCurrencyId = $method->payment_currency;
    }

    function plgVmOnPaymentResponseReceived(&$html)
    {

        if (!class_exists('VirtueMartCart')) {
            require(VMPATH_SITE . DS . 'helpers' . DS . 'cart.php');
        }
        if (!class_exists('shopFunctionsF')) {
            require(VMPATH_SITE . DS . 'helpers' . DS . 'shopfunctionsf.php');
        }
        if (!class_exists('VirtueMartModelOrders')) {
            require(VMPATH_ADMIN . DS . 'models' . DS . 'orders.php');
        }

        VmConfig::loadJLang('com_virtuemart_orders', TRUE);
        $mb_data = vRequest::getPost();


        // the payment itself should send the parameter needed.
        $virtuemart_paymentmethod_id = vRequest::getInt('pm', 0);
        $order_number = vRequest::getString('on', 0);
        if (!($method = $this->getVmPluginMethod($virtuemart_paymentmethod_id))) {
            return NULL;
        } // Another method was selected, do nothing

        if (!$this->selectedThisElement($method->payment_element)) {
            return NULL;
        }

        if (!($virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber($order_number))) {
            return NULL;
        }

        if (!($paymentTable = $this->getDataByOrderId($virtuemart_order_id))) {
            // JError::raiseWarning(500, $db->getErrorMsg());
            return '';
        }
        VmConfig::loadJLang('com_virtuemart');
        $orderModel = VmModel::getModel('orders');
        $order = $orderModel->getOrder($virtuemart_order_id);

        vmdebug('mypos plgVmOnPaymentResponseReceived', $mb_data);
        $payment_name = $this->renderPluginName($method);
        $html = $this->_getPaymentResponseHtml($paymentTable, $payment_name);
        $link = JRoute::_("index.php?option=com_virtuemart&view=orders&layout=details&order_number=" . $order['details']['BT']->order_number . "&order_pass=" . $order['details']['BT']->order_pass, false);

        $html .= '<br />
		<a class="vm-button-correct" href="' . $link . '">' . vmText::_('COM_VIRTUEMART_ORDER_VIEW_ORDER') . '</a>';

        $cart = VirtueMartCart::getCart();
        $cart->emptyCart();
        return TRUE;
    }

    function _getPaymentResponseHtml($paymentTable, $payment_name)
    {
        VmConfig::loadJLang('com_virtuemart');

        $html = '<table>' . "\n";
        $html .= $this->getHtmlRow('COM_VIRTUEMART_PAYMENT_NAME', $payment_name);
        if (!empty($paymentTable)) {
            $html .= $this->getHtmlRow('mypos_ORDER_NUMBER', $paymentTable->order_number);
        }
        $html .= '</table>' . "\n";

        return $html;
    }

    function plgVmOnUserPaymentCancel()
    {

        if (!class_exists('VirtueMartModelOrders')) {
            require(VMPATH_ADMIN . DS . 'models' . DS . 'orders.php');
        }

        $order_number = vRequest::getString('on', '');
        $virtuemart_paymentmethod_id = vRequest::getInt('pm', '');
        if (empty($order_number) or
            empty($virtuemart_paymentmethod_id) or
            !$this->selectedThisByMethodId($virtuemart_paymentmethod_id)
        ) {
            return NULL;
        }

        if (!($virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber($order_number))) {
            return NULL;
        }

        if (!($paymentTable = $this->getDataByOrderId($virtuemart_order_id))) {
            return NULL;
        }

        VmInfo(vmText::_('VMPAYMENT_mypos_PAYMENT_CANCELLED'));
        $session = JFactory::getSession();
        $return_context = $session->getId();
        if (strcmp($paymentTable->user_session, $return_context) === 0) {
            $this->handlePaymentUserCancel($virtuemart_order_id);
        }

        return TRUE;
    }

    function plgVmOnPaymentNotification()
    {
        // $virtuemart_paymentmethod_id = JRequest::getInt('pm', 0);
        // $method = $this->getVmPluginMethod($virtuemart_paymentmethod_id);
        // if (!$this->selectedThisElement($method->payment_element)) {
        //     return false;
        // }

        // $post = JRequest::get('POST');

        $app = JFactory::getApplication();
        
        $virtuemart_paymentmethod_id = $app->input->getCmd('pm', 0);
        $method = $this->getVmPluginMethod($virtuemart_paymentmethod_id);
        
        if (!$this->selectedThisElement($method->payment_element)) {
            return false;
        }
        
        $post = $app->input->post->getArray();

        $test = $method->test;

        if (!$test) {
            $packageData = json_decode(base64_decode($method->production_package), true);

            $public_certificate = !empty($packageData['pc']) ? $packageData['pc'] : $method->production_public_certificate;
        } else {
            $packageData = json_decode(base64_decode($method->developer_package), true);

            $public_certificate = !empty($packageData['pc']) ? $packageData['pc'] : $method->developer_public_certificate;
        }

        if (!class_exists('VirtueMartModelOrders')) {
            require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
        }

        if ($this->is_valid_signature($post, $public_certificate)) {
            if ($test) {
                $post['OrderID'] = preg_replace('/^.*?_/', '', $post['OrderID']);
            }
            $invoice = intval($post['OrderID']);
            $this->logInfo("Real order id: " . $invoice);
            $this->logInfo("IPCmethod: " . $post['IPCmethod']);

            if ($post['IPCmethod'] == 'IPCPurchaseNotify') {
                $modelOrder = VmModel::getModel('orders');
                $order['order_status'] = 'C';
                $order['customer_notified'] = 1;
                $order['comments'] = 'myPOS';
                $modelOrder->updateStatusForOneOrder($invoice, $order, true);
                $this->logInfo("Answer IPCPurchaseNotify for invoice: " . $invoice);
                echo 'OK';
                exit;
            } else if ($post['IPCmethod'] == 'IPCPurchaseOK') {
                $modelOrder = VmModel::getModel('orders');
                $order['order_status'] = 'C';
                $order['customer_notified'] = 1;
                $order['comments'] = 'myPOS';
                $modelOrder->updateStatusForOneOrder($invoice, $order, true);
            } else if ($post['IPCmethod'] == 'IPCPurchaseRollback') {
                $modelOrder = VmModel::getModel('orders');
                $order['order_status'] = 'X';
                $order['customer_notified'] = 1;
                $order['comments'] = 'myPOS';
                $modelOrder->updateStatusForOneOrder($invoice, $order, true);
                echo 'OK';
                exit;
            } else if ($post['IPCmethod'] == 'IPCPurchaseCancel') {
                $modelOrder = VmModel::getModel('orders');
                $order['order_status'] = 'X';
                $order['customer_notified'] = 1;
                $order['comments'] = 'myPOS';
                $modelOrder->updateStatusForOneOrder($invoice, $order, true);
            } else {
                echo 'INVALID METHOD';
                exit;
            }
        } else {
            echo 'INVALID SIGNATURE';
            exit;
        }
        echo 'OK';
        exit;
    }

    function is_valid_signature($post, $public_certificate)
    {
        $this->logInfo("Checking signature for order: " . $post['OrderID']);

        // Save signature
        $signature = $post['Signature'];

        // Remove signature from POST data array
        unset($post['Signature']);

        // Concatenate all values
        $concData = base64_encode(implode('-', $post));

        // Extract public key from certificate
        $pubKeyId = openssl_get_publickey($public_certificate);

        // Verify signature
        $result = openssl_verify($concData, base64_decode($signature), $pubKeyId, OPENSSL_ALGO_SHA256);

        //Free key resource
        openssl_free_key($pubKeyId);

        if ($result == 1) {
            return true;
        } else {
            return false;
        }
    }

    function plgVmOnShowOrderBEPayment($virtuemart_order_id, $payment_method_id)
    {

        if (!$this->selectedThisByMethodId($payment_method_id)) {
            return NULL;
        } // Another method was selected, do nothing

        if (!($paymentTable = $this->_getInternalData($virtuemart_order_id))) {
            // JError::raiseWarning(500, $db->getErrorMsg());
            return '';
        }

        $this->getPaymentCurrency($paymentTable);
        $q = 'SELECT `currency_code_3` FROM `#__virtuemart_currencies` WHERE `virtuemart_currency_id`="' .
            $paymentTable->payment_currency . '" ';
        $db = JFactory::getDBO();
        $db->setQuery($q);
        $currency_code_3 = $db->loadResult();
        $html = '<table class="adminlist table">' . "\n";
        $html .= $this->getHtmlHeaderBE();
        $html .= $this->getHtmlRowBE('PAYMENT_NAME', $paymentTable->payment_name);

        $code = "mb_";
        foreach ($paymentTable as $key => $value) {
            if (substr($key, 0, strlen($code)) == $code) {
                $html .= $this->getHtmlRowBE($key, $value);
            }
        }
        $html .= '</table>' . "\n";
        return $html;
    }


    /**
     * We must reimplement this triggers for joomla 1.7
     */

    function _getInternalData($virtuemart_order_id, $order_number = '')
    {

        $db = JFactory::getDBO();
        $q = 'SELECT * FROM `' . $this->_tablename . '` WHERE ';
        if ($order_number) {
            $q .= " `order_number` = '" . $order_number . "'";
        } else {
            $q .= ' `virtuemart_order_id` = ' . $virtuemart_order_id;
        }

        $db->setQuery($q);
        if (!($paymentTable = $db->loadObject())) {
            // JError::raiseWarning(500, $db->getErrorMsg());
            return '';
        }
        return $paymentTable;
    }

    /**
     * Create the table for this plugin if it does not yet exist.
     * This functions checks if the called plugin is active one.
     * When yes it is calling the standard method to create the tables
     *
     * @author Valérie Isaksen
     *
     */
    function plgVmOnStoreInstallPaymentPluginTable($jplugin_id)
    {

        return $this->onStoreInstallPluginTable($jplugin_id);
    }

    /**
     * This event is fired after the payment method has been selected. It can be used to store
     * additional payment info in the cart.
     *
     * @param VirtueMartCart $cart : the actual cart
     * @return null if the payment was not selected, true if the data is valid, error message if the data is not valid
     *
     * @author Max Milbers
     * @author Valérie isaksen
     *
     */
    public function plgVmOnSelectCheckPayment(VirtueMartCart $cart, &$msg)
    {

        return $this->OnSelectCheck($cart);
    }

    /**
     * plgVmDisplayListFEPayment
     * This event is fired to display the pluginmethods in the cart (edit shipment/payment) for exampel
     *
     * @param object $cart Cart object
     * @param integer $selected ID of the method selected
     * @return boolean True on success, false on failures, null when this plugin was not selected.
     * On errors, JError::raiseWarning (or JError::raiseError) must be used to set a message.
     *
     * @author Valerie Isaksen
     * @author Max Milbers
     */
    public function plgVmDisplayListFEPayment(VirtueMartCart $cart, $selected = 0, &$htmlIn)
    {

        return $this->displayListFE($cart, $selected, $htmlIn);
    }

    public function plgVmonSelectedCalculatePricePayment(VirtueMartCart $cart, array &$cart_prices, &$cart_prices_name)
    {

        return $this->onSelectedCalculatePrice($cart, $cart_prices, $cart_prices_name);
    }

    /**
     * plgVmOnCheckAutomaticSelectedPayment
     * Checks how many plugins are available. If only one, the user will not have the choice. Enter edit_xxx page
     * The plugin must check first if it is the correct type
     *
     * @param VirtueMartCart cart: the cart object
     * @return null if no plugin was found, 0 if more then one plugin was found,  virtuemart_xxx_id if only one plugin is found
     *
     * @author Valerie Isaksen
     */
    function plgVmOnCheckAutomaticSelectedPayment(VirtueMartCart $cart, array $cart_prices = array(), &$paymentCounter)
    {

        return $this->onCheckAutomaticSelected($cart, $cart_prices, $paymentCounter);
    }

    /**
     * This event is fired during the checkout process. It can be used to validate the
     * method data as entered by the user.
     *
     * @return boolean True when the data was valid, false otherwise. If the plugin is not activated, it should return null.
     * @author Max Milbers
     *
     * public function plgVmOnCheckoutCheckDataPayment($psType, VirtueMartCart $cart) {
     * return null;
     * }
     */

    /**
     * This method is fired when showing the order details in the frontend.
     * It displays the method-specific data.
     *
     * @param integer $order_id The order ID
     * @return mixed Null for methods that aren't active, text (HTML) otherwise
     * @author Max Milbers
     * @author Valerie Isaksen
     */
    public function plgVmOnShowOrderFEPayment($virtuemart_order_id, $virtuemart_paymentmethod_id, &$payment_name)
    {

        $this->onShowOrderFE($virtuemart_order_id, $virtuemart_paymentmethod_id, $payment_name);
    }

    /**
     * Save updated order data to the method specific table
     *
     * @param array $_formData Form data
     * @return mixed, True on success, false on failures (the rest of the save-process will be
     * skipped!), or null when this method is not activated.
     *
     * public function plgVmOnUpdateOrderPayment(  $_formData) {
     * return null;
     * }
     */
    /**
     * Save updated orderline data to the method specific table
     *
     * @param array $_formData Form data
     * @return mixed, True on success, false on failures (the rest of the save-process will be
     * skipped!), or null when this method is not actived.
     *
     * public function plgVmOnUpdateOrderLine(  $_formData) {
     * return null;
     * }
     */
    /**
     * plgVmOnEditOrderLineBE
     * This method is fired when editing the order line details in the backend.
     * It can be used to add line specific package codes
     *
     * @param integer $_orderId The order ID
     * @param integer $_lineId
     * @return mixed Null for method that aren't active, text (HTML) otherwise
     *
     * public function plgVmOnEditOrderLineBE(  $_orderId, $_lineId) {
     * return null;
     * }
     */

    /**
     * This method is fired when showing when priting an Order
     * It displays the the payment method-specific data.
     *
     * @param integer $_virtuemart_order_id The order ID
     * @param integer $method_id method used for this order
     * @return mixed Null when for payment methods that were not selected, text (HTML) otherwise
     * @author Valerie Isaksen
     */
    function plgVmonShowOrderPrintPayment($order_number, $method_id)
    {

        return $this->onShowOrderPrint($order_number, $method_id);
    }

    /**
     * This method is fired when showing the order details in the frontend, for every orderline.
     * It can be used to display line specific package codes, e.g. with a link to external tracking and
     * tracing systems
     *
     * @param integer $_orderId The order ID
     * @param integer $_lineId
     * @return mixed Null for method that aren't active, text (HTML) otherwise
     *
     * public function plgVmOnShowOrderLineFE(  $_orderId, $_lineId) {
     * return null;
     * }
     */
    function plgVmDeclarePluginParamsPaymentVM3(&$data)
    {
        return $this->declarePluginParams('payment', $data);
    }

    function plgVmSetOnTablePluginParamsPayment($name, $id, &$table)
    {

        return $this->setOnTablePluginParams($name, $id, $table);
    }

    protected function checkConditions($cart, $method, $cart_prices)
    {

        $this->convert_condition_amount($method);

        $address = (($cart->ST == 0) ? $cart->BT : $cart->ST);

        $amount = $this->getCartAmount($cart_prices);
        $amount_cond = ($amount >= $method->min_amount and $amount <= $method->max_amount
            or
            ($method->min_amount <= $amount and ($method->max_amount == 0)));

        $countries = array();
        if (!empty($method->countries)) {
            if (!is_array($method->countries)) {
                $countries[0] = $method->countries;
            } else {
                $countries = $method->countries;
            }
        }

        // probably did not gave his BT:ST address
        if (!is_array($address)) {
            $address = array();
            $address['virtuemart_country_id'] = 0;
        }

        if (!isset($address['virtuemart_country_id'])) {
            $address['virtuemart_country_id'] = 0;
        }
        if (in_array($address['virtuemart_country_id'], $countries) || count($countries) == 0) {
            if ($amount_cond) {
                return TRUE;
            }
        }

        return FALSE;
    }
} // end of class plgVmpaymentmypos

// No closing tag
