<?php

include_once(dirname(__FILE__).'/../../config/config.inc.php');
include_once(dirname(__FILE__).'/../../init.php');
include_once(_PS_MODULE_DIR_.'myposvirtual/myposvirtual.php');

$myposVirtual = new MyposVirtual();

$config = $myposVirtual->getMyposVirtualConfig();

if (Tools::isSubmit('Signature')) {
    try {
        $response = \Mypos\IPC\Response::getInstance($config, $_POST, \Mypos\IPC\Defines::COMMUNICATION_FORMAT_POST);
        $data = $response->getData(CASE_LOWER);

        if (Configuration::get('mypos_virtual_test_mode')) {
            $data['orderid'] = str_replace(Configuration::get('mypos_virtual_test_prefix'), '', $data['orderid']);
        }

        $cart = new Cart($data['orderid']);

        if ($cart->orderExists()) {
            $order = new Order((int)Order::getOrderByCartId($cart->id));
            $new_history = new OrderHistory();
            $new_history->id_order = (int)$order->id;
            $new_history->changeIdOrderState(Configuration::get('PS_OS_CANCELED'), $order->id);
            $new_history->add();
        }
    } catch(\Mypos\IPC\IPC_Exception $e) {
        Logger::AddLog('myPOS Checkout: ' . $e->getMessage());
    }
}

Tools::redirect('/order.php');
