<?php

include_once(dirname(__FILE__).'/../../config/config.inc.php');
include_once(dirname(__FILE__).'/../../init.php');
include_once(_PS_MODULE_DIR_.'myposvirtual/myposvirtual.php');

$myposVirtual = new MyposVirtual();

$config = $myposVirtual->getMyposVirtualConfig();

if (!Tools::isSubmit('Signature')) {
    die('Invalid request.');
} else {
    try{

        $response = \Mypos\IPC\Response::getInstance($config, $_POST, \Mypos\IPC\Defines::COMMUNICATION_FORMAT_POST);
        $data = $response->getData(CASE_LOWER);

        if (Configuration::get('mypos_virtual_test_mode')) {
            $data['orderid'] = str_replace(Configuration::get('mypos_virtual_test_prefix'), '', $data['orderid']);
        }

        $cart = new Cart($data['orderid']);

        if (!Validate::isLoadedObject($cart)) {
            die('Invalid cart ID');
        }

        $currency = new Currency((int)Currency::getIdByIsoCode($data['currency']));

        if (!Validate::isLoadedObject($currency) || $currency->id != $cart->id_currency) {
            die('Invalid currency ID');
        }

        if ($data['amount'] != $cart->getOrderTotal(true)) {
            var_dump($data['amount']); echo '<br/>';
            var_dump($cart->getOrderTotal(true)); echo '<br/>';
            die('Invalid amount paid');
        }

        $order = new Order((int)Order::getOrderByCartId($cart->id));

        switch($data['ipcmethod']) {
            case 'IPCPurchaseNotify':
                $order_status = _PS_OS_PAYMENT_;

                if ($order->getCurrentState() == $order_status) {
                     die('Same status');
                }

                if ($cart->orderExists())
                {
                    $myposVirtual->addTransactionId((int)$myposVirtual->currentOrder, $data['ipc_trnref']);

                    $myposVirtual->addTransaction('payment', array(
                        'id_customer' => (int)$cart->id_customer,
                        'id_cart' => (int)$cart->id,
                        'id_order' => (int)$order->id,
                        'id_transaction' => $data['ipc_trnref'],
                        'amount' => (float)$data['amount'],
                        'currency' => $data['currency'],
                    ));

                    $order->setInvoice();
                    $new_history = new OrderHistory();
                    $new_history->id_order = (int)$order->id;
                    $new_history->changeIdOrderState($order_status, $order, true);
                    $new_history->addWithemail(true);

                } else {
                    $customer = new Customer((int)$cart->id_customer);

                    $message =
                    'IPCmethod: '. $data['ipcmethod'] .'
                    SID: '. $data['sid'] .'
                    Amount: '. $data['amount'] .'
                    Currency: '. $data['currency'] .'
                    OrderID: '. $data['orderid'] .'
                    IPC_Trnref: '. $data['ipc_trnref'] .'
                    RequestSTAN: '. $data['requeststan'] .'
                    RequestDateTime: '. $data['requestdatetime'] .'
                    Mode: '. ($myposVirtual->scope === 'mvd' ? 'developer' : 'production');

                    if ($myposVirtual->validateOrder($cart->id, $order_status, $data['amount'], $myposVirtual->displayName, $message, array(), null, false, $customer->secure_key, null))
                    {
                        $myposVirtual->addTransactionId((int)$myposVirtual->currentOrder, $data['ipc_trnref']);

                        $myposVirtual->addTransaction('payment', array(
                            'id_customer' => (int)$cart->id_customer,
                            'id_cart' => (int)$cart->id,
                            'id_order' => (int)$myposVirtual->currentOrder,
                            'id_transaction' => $data['ipc_trnref'],
                            'amount' => (float)$data['amount'],
                            'currency' => $data['currency'],
                        ));
                    }
                }

                die('OK');
            case 'IPCPurchaseRollback':
                $order_status = _PS_OS_ERROR_;

                if ($cart->orderExists())
                {
                    $new_history = new OrderHistory();
                    $new_history->id_order = (int)$order->id;
                    $new_history->changeIdOrderState((int)($order_status), (int)($order->id));
                    $new_history->addWithemail(true);
                } else {
                    die('Order not found for this cart.');
                }

                die('OK');
            default:
                die('Invalid method.');
        }
    } catch(\Mypos\IPC\IPC_Exception $e) {
        die('ERROR: ' . $e);
    }
}
