<?php

include_once(dirname(__FILE__).'/../../config/config.inc.php');
include_once(dirname(__FILE__).'/../../init.php');
include_once(_PS_MODULE_DIR_.'myposvirtual/myposvirtual.php');

$myposVirtual = new MyposVirtual();

$config = $myposVirtual->getMyposVirtualConfig();

if (array_key_exists('process_payment', $_POST)) {
    ini_set('display_errors', 1);
    error_reporting(E_ALL);

    global $cart, $cookie;

    if (method_exists('Tools', 'getShopDomainSsl')) {
        $url = 'https://' . Tools::getShopDomainSsl() . __PS_BASE_URI__ . '/modules/' . $myposVirtual->name . '/';
    } else {
        $url = 'https://' . $_SERVER['HTTP_HOST'] . __PS_BASE_URI__ . 'modules/' . $myposVirtual->name . '/';
    }

    $currency = new Currency((int)($cart->id_currency));

    // Getting address
    if (isset($cookie->id_cart) AND $cookie->id_cart) {
        $cart = new Cart((int)($cookie->id_cart));
    }

    if (isset($cart->id_address_delivery) AND $cart->id_address_delivery) {
        $address = new Address((int)($cart->id_address_delivery));
    }

    if (!Validate::isLoadedObject($address))
    {
        return;
    }

    $country = new Country((int)($address->id_country));
    $state = new State((int)($address->id_state));
    $cartObject = $cart;
    $isoCodes = require 'countries.php';
    $isoCode = $isoCodes[$country->iso_code];

    require_once __DIR__ . '/sdk/Loader.php';

    try {
        $myConfig = $myposVirtual->getMyposVirtualConfig();
        $myCustomer = $myposVirtual->getMyposVirtualCustomer($cookie, $address, $isoCode);
        $myCart = $myposVirtual->getMyposVirtualCart($cartObject);
        $myPurchase = $myposVirtual->getMyposVirtualPurchase($myConfig, $cartObject, $currency->iso_code, $myCustomer, $myCart, $cookie);

        $myPurchase->validate();

        if (in_array($myposVirtual->getMyposVirtualPaymentMethod(), [2, 3])) {
            $cartTotal = $cartObject->getOrderTotal(true);
            $awaiting_state = new OrderState((int)Configuration::get('awaiting_mypos_order_state_id'));
            $customer = new Customer((int)$cart->id_customer);

            //create order with status Awaiting Payment
            $myposVirtual->validateOrder(
                (int)$cartObject->id,
                $awaiting_state->id,
                $cartTotal,
                $myposVirtual->displayName,
                "",
                [
                    '{payment}' => $awaiting_state->name[$cartObject->id_lang],
                ],
                (int)$currency->id,
                false,
                $customer->secure_key
            );
        }
        $myPurchase->process();
    } catch (\Mypos\IPC\IPC_Exception $exception) {
        var_dump($exception->getMessage());die;
    }
}