<?php

use Mypos\IPC\Defines;

class MyposVirtualNotifyModuleFrontController extends ModuleFrontController
{
    private $mypos_virtual;

    /**
	* @see FrontController::initContent()
	*/
	public function initContent()
	{
		$this->mypos_virtual = new MyposVirtual();

		if ($this->mypos_virtual->active)
		{
			parent::initContent();

            $context = Context::getContext();

            require_once __DIR__ . '/../../sdk/Loader.php';

            $config = $this->mypos_virtual->getMyposVirtualConfig();

            if (Tools::isSubmit('Signature')) {
                try{
                    $response = \Mypos\IPC\Response::getInstance($config, $_POST, Defines::COMMUNICATION_FORMAT_POST);
                    $data = $response->getData(CASE_LOWER);

                    if (Configuration::get('mypos_virtual_test_mode')) {
                        $data['orderid'] = str_replace(Configuration::get('mypos_virtual_test_prefix'), '', $data['orderid']);
                    }

                    $cart = new Cart($data['orderid']);

                    if (!Validate::isLoadedObject($cart)) {
                        die('Invalid cart ID');
                    }

                    $currency = new Currency((int)Currency::getIdByIsoCode($data['currency']));

                    if (!Validate::isLoadedObject($currency) || $currency->id != $cart->id_currency) {
                        die('Invalid currency ID');
                    }

                    $context->currency = $currency;

                    if ($data['amount'] != $cart->getOrderTotal(true)) {
                    	var_dump($data['amount']); echo '<br/>';
                    	var_dump($cart->getOrderTotal(true)); echo '<br/>';
                        die('Invalid amount paid');
                    }

                    switch($data['ipcmethod'])
                    {
                        case 'IPCPurchaseNotify':
                            $order_status = Configuration::get('PS_OS_PAYMENT');

                            if ($cart->orderExists())
                            {
                                $order = new Order((int)Order::getOrderByCartId($cart->id));

                                $this->module->addTransaction('payment', array(
                                    'id_shop' => (int)$cart->id_shop,
                                    'id_customer' => (int)$cart->id_customer,
                                    'id_cart' => (int)$cart->id,
                                    'id_order' => $order->id,
                                    'id_transaction' => $data['ipc_trnref'],
                                    'amount' => (float)$data['amount'],
                                    'currency' => $data['currency'],
                                ));

                                //add payment
                                if (!$order->addOrderPayment((float)$data['amount'], null, $data['ipc_trnref'])) {
                                    PrestaShopLogger::addLog('PaymentModule::validateOrder - Cannot save Order Payment', 3, null, 'Cart', (int)$cart->id, true);
                                    throw new PrestaShopException('Can\'t save Order Payment');
                                } else {
                                    $order_status = Configuration::get('PS_OS_PAYMENT');
                                    $new_history = new OrderHistory();
                                    $new_history->id_order = (int)$order->id;
                                    $new_history->changeIdOrderState($order_status, $order, true);
                                    $new_history->addWithemail(true);
                                }

                                die('OK');
                            } else {
                                $customer = new Customer((int)$cart->id_customer);
                                $context->customer = $customer;

                                $message =
                                'IPCmethod: '. $data['ipcmethod'] .'
								SID: '. $data['sid'] .'
								Amount: '. $data['amount'] .'
								Currency: '. $data['currency'] .'
								OrderID: '. $data['orderid'] .'
								IPC_Trnref: '. $data['ipc_trnref'] .'
								RequestSTAN: '. $data['requeststan'] .'
								RequestDateTime: '. $data['requestdatetime'] .'
								Signature: '. $data['signature'] .'
								Mode: '. $this->mypos_virtual->scope;

                                if ($this->mypos_virtual->validateOrder($cart->id, $order_status, $data['amount'], $this->mypos_virtual->displayName, $message, array(), null, false, $customer->secure_key, null))
                                {
                                    $this->mypos_virtual->addTransactionId((int)$this->mypos_virtual->currentOrder, $data['ipc_trnref']);

                                    $this->mypos_virtual->addTransaction('payment', array(
                                        'id_shop' => (int)$cart->id_shop,
                                        'id_customer' => (int)$cart->id_customer,
                                        'id_cart' => (int)$cart->id,
                                        'id_order' => (int)$this->mypos_virtual->currentOrder,
                                        'id_transaction' => $data['ipc_trnref'],
                                        'amount' => (float)$data['amount'],
                                        'currency' => $data['currency'],
                                    ));

                                    die('OK');
                                } else {
                                    die('ERROR CREATING ORDER!');
                                }
                            }


                        case 'IPCPurchaseRollback':
                            $order_status = Configuration::get('PS_OS_ERROR');

                            if ($cart->orderExists())
                            {
                                $order = new Order((int)Order::getOrderByCartId($cart->id));
                                $new_history = new OrderHistory();
                                $new_history->id_order = (int)$order->id;
                                $new_history->changeIdOrderState($order_status, $order, true);
                                $new_history->addWithemail(true);
                            } else {
                                die('Order not found for this cart.');
                            }

                            die('OK');
                        default:
                            die('Invalid method.');
                    }
                } catch(\Mypos\IPC\IPC_Exception $e) {
                    die($e->getMessage());
                }
            }
		}
	}
}
