<?php

namespace XLite\Module\IPAYINTERNATIONAL\MyPOSVirtual\Controller\Admin;

use \XLite\Module\IPAYINTERNATIONAL\MyPOSVirtual\Model\Payment\Processor\MyPOSVirtual;

class Order extends \XLite\Controller\Admin\Order implements \XLite\Base\IDecorator
{
    public function handleRequest()
    {
        $request = \XLite\Core\Request::getInstance();
        
        if (!$request->isPost()) {
            return parent::handleRequest();
        }

        $orderid = $request->order_id;

        $order = \XLite\Core\Database::getRepo('XLite\Model\Order')->find($orderid);
        if (!$order) {
            return parent::handleRequest();
        }

        $extra = array();
        $_details = $order->getDetails();
        if ($_details) {
            foreach ($_details as $_detail) {
                $extra[$_detail->getName()] = $_detail->getValue();
            }
        }

        switch ($request->action) {
            case 'mypos_refund':
                $trnRef = $order->getDetail('IPC_Trnref');
                if (empty($trnRef)) {
                    return parent::handleRequest();
                }
                
                $transactions = $order->getPaymentTransactions();
                if (empty($transactions)) {
                    return parent::handleRequest();
                }
                
                $paidWithMyposVirtual = false;
                foreach ($transactions as $_transaction) {
                    if (($_transaction->getType() == \XLite\Model\Payment\BackendTransaction::TRAN_TYPE_SALE)
                    && ($_transaction->getStatus() == \XLite\Model\Payment\Transaction::STATUS_SUCCESS)
                    ) {
                        $paymentMethod = $_transaction->getPaymentMethod();
                        if (!empty($paymentMethod)) {
                            $paymentProcessor = $paymentMethod->getProcessor();
                            if ($paymentProcessor instanceof MyPOSVirtual) {
                                $paidWithMyposVirtual = true;
                                break;
                            }
                        }
                    }
                }
                
                if (!$paidWithMyposVirtual) {
                    return parent::handleRequest();
                }
                
                $postData = $request->getPostData();
                
                $amount = floatval($postData['mypos_refund_amount']);
                if ($amount <= 0) {
                    \XLite\Core\TopMessage::addError(static::t('invalid_refund_amount'));
                    
                    return parent::handleRequest();
                }
                
                $trnRef = $order->getDetail('IPC_Trnref')->getValue();
                $orderId = $order->getOrderId();
                $currency = $order->getCurrency();
                $orderTotal = $currency->roundValue($order->getTotal());
                $transactionSums = $order->getRawPaymentTransactionSums();
                
                if ($currency->roundValue($transactionSums['refunded'] + $amount) > $orderTotal) {
                    \XLite\Core\TopMessage::addError(static::t('invalid_refund_amount'));
                    
                    return parent::handleRequest();
                }
                
                $transaction = new \XLite\Model\Payment\Transaction();

                $transaction->setPaymentMethod($paymentMethod);
                
                $paymentProcessor->setTransactionProperty($transaction);
                
                $result = $paymentProcessor->makeRefundApiCall($trnRef, $orderId, $amount, $currency->getCode());
                
                if (isset($result['Status']) && ($result['Status'] == 0)) {
                    // add a refund transaction
                    $transactionType = \XLite\Model\Payment\BackendTransaction::TRAN_TYPE_REFUND_PART;
                    $paymentStatus = \XLite\Model\Order\Status\Payment::STATUS_PART_PAID;
                    if ($currency->roundValue($transactionSums['refunded'] + $amount) == $orderTotal) {
                        $transactionType = \XLite\Model\Payment\BackendTransaction::TRAN_TYPE_REFUND;
                        $paymentStatus = \XLite\Model\Order\Status\Payment::STATUS_REFUNDED;
                    }
                    
                    $em = \XLite\Core\Database::getEM();
                    
                    $em->persist($paymentMethod);

                    $transaction->setOrder($order);
                    $order->addPaymentTransactions($transaction);
                    $transaction->setCurrency($order->getCurrency());
                    $transaction->setStatus(\XLite\Model\Payment\Transaction::STATUS_SUCCESS);
                    $transaction->setValue($amount);
                    $transaction->setType($transactionType);

                    if ($paymentMethod->getProcessor()->isTestMode($paymentMethod)) {
                        $transaction->setDataCell(
                            'test_mode',
                            true,
                            'Test mode'
                        );
                    }

                    $order->setPaymentStatus($paymentStatus);
                    
                    $em->persist($order);
                    $em->persist($transaction);
                    
                    $em->flush();
                    
                    \XLite\Core\TopMessage::addInfo(static::t('successful_refund'));
                } else {
                    $errMsg = $result['StatusMsg'];
                    $errorMsg = static::t('refund_error_msg', array('errMsg' => $errMsg));
                    \XLite\Core\TopMessage::addError($errorMsg);
                }
                
                break;
            case 'mypos_check_payment_status':
                $myPOSVirtual = new MyPOSVirtual();
                $result = $myPOSVirtual->checkPaymentStatusApiCall($orderid);

                if ($orderid == $result['OrderID']
                    && array_key_exists('PaymentStatus', $result)
                ) {

                    $transactions = $order->getPaymentTransactions();

                    $paidWithMyposVirtual = false;
                    foreach ($transactions as $_transaction) {

                        if (($_transaction->getType() == \XLite\Model\Payment\BackendTransaction::TRAN_TYPE_SALE)
                            && ($_transaction->getStatus() == \XLite\Model\Payment\Transaction::STATUS_INPROGRESS)
                        ) {
                            $paymentMethod = $_transaction->getPaymentMethod();
                            if (!empty($paymentMethod)) {
                                $paymentProcessor = $paymentMethod->getProcessor();
                                if ($paymentProcessor instanceof MyPOSVirtual) {
                                    $paidWithMyposVirtual = true;
                                    break;
                                }
                            }
                        }
                    }

                    if(!$paidWithMyposVirtual) {
                        parent::handleRequest();
                    } else {
                        $transaction = $_transaction;
                    }

                    switch ($result['PaymentStatus'])
                    {
                        case MyPOSVirtual::PAYMENT_STATUS_SUCCESS:
                            $transaction->setStatus(\XLite\Model\Payment\Transaction::STATUS_SUCCESS);
                            $order->setPaymentStatus(\XLite\Model\Order\Status\Payment::STATUS_PAID);
                            \XLite\Core\TopMessage::addInfo(static::t('order_payment_authorized'));
                            break;
                        case MyPOSVirtual::PAYMENT_METHOD_ERROR:

                            $transaction->setStatus(\XLite\Model\Payment\Transaction::STATUS_FAILED);
                            $order->setPaymentStatus(\XLite\Model\Order\Status\Payment::STATUS_DECLINED);
                            \XLite\Core\TopMessage::addError(static::t('order_payment_error'));
                        case MyPOSVirtual::PAYMENT_METHOD_EXPIRED:
                            $transaction->setStatus(\XLite\Model\Payment\Transaction::STATUS_FAILED);
                            $order->setPaymentStatus(\XLite\Model\Order\Status\Payment::STATUS_DECLINED);
                            \XLite\Core\TopMessage::addError(static::t('order_payment_expired'));
                    }

                    $em = \XLite\Core\Database::getEM();
                    $em->persist($order);
                    $em->persist($transaction);

                    $em->flush();

                }
                break;
        }
        
        return parent::handleRequest();
    }
}
