<?php

namespace XLite\Module\IPAYINTERNATIONAL\MyPOSVirtual\View;

abstract class AView extends \XLite\View\AView implements \XLite\Base\IDecorator
{
    public function getModuleTitle()
    {
        return \XLite\Module\IPAYINTERNATIONAL\MyPOSVirtual\Main::getModuleName();
    }
    
    // looks like there is no way to display "{" and "}" in flexy, so use this hack
    public function getLdelim()
    {
        return '{';
    }

    public function getRdelim()
    {
        return '}';
    }
    
    public function getOrderDetail($str)
    {
        $order = $this->get('order');
        if ($order && $order->getDetail($str)) {
            return (string)$order->getDetail($str)->getValue();
        } else {
            return '';
        }
    }

    public function isRefundControlVisible()
    {
        $order = $this->get('order');
        if ($order) {
            if (($order->getPaymentStatusCode() == \XLite\Model\Order\Status\Payment::STATUS_PAID)
            || ($order->getPaymentStatusCode() == \XLite\Model\Order\Status\Payment::STATUS_PART_PAID)
            ) {
                $transactionSums = $order->getRawPaymentTransactionSums();
                
                return ($transactionSums['refunded'] < $order->getTotal());
            }
        }
        return false;
    }
    
    public function isMyposControlsVisible()
    {
        $trnRef = $this->getOrderDetail('IPC_Trnref');
        return !empty($trnRef);
    }
}
